 ; Ŀ
 ;   Crab - line up a circle, line, and circle.                            
 ;   Copyright 1994, 1995, 1997, 1998, 2002, 2010 by Rocket Software Ltd.  
 ;   What parts of us do fiddler crabs look at and think: "They only       
 ;   evolved that to get chicks"?                                          
 ; 

 ; Ŀ
 ;   Subroutine Acirc: find the appropriate circle or arc in a block def.  
 ;   Takes one argument, the block head data.                              
 ;   Returns Grsub, apparently a list of the radius and centre of the      
 ;   largest arc/circle in the block definition, or nil if there are none. 
 ;   Change: need to return a zero radius and the insertion point if       
 ;   there are no circles or arcs.                                         
 ;                                                                         
 ;   Bear in mind that the ten point is an offset from the block           
 ;   insertion point, it must be moved and scaled with the block.          
 ; 
 (DEFUN ACIRC (blnam / blok namm entt typp clist grsub sub grdiam num)
  (setq blnam (cdr (assoc 2 blnam)))        ; block definition name
 ; Ŀ
 ;   Find the block definition in the block table.                         
 ; 
  (setq blok (tblsearch "block" blnam))     ; head data from table
  (setq namm (cdr (assoc -2 blok)))         ; first ename after head
 ; Ŀ
 ;   The 10 association code from the subentity data represents an offset  
 ;   from the insertion point.                                             
 ; 
  (setq typp (cdr (assoc 0 (setq entt (entget namm)))))
  (if (member typp '("ARC" "CIRCLE"))
 ; Ŀ
 ;   If the entity was an arc or circle then append the centre point and   
 ;   radius to the list for later appraisal.                               
 ; 
      (setq clist (append clist (list (list (cdr (assoc 40 entt))
                                                    (cdr (assoc 10 entt)))))))
 ; Ŀ
 ;   Note: entnext returns nil after the last entity in a block            
 ;   definition.                                                           
 ; 
  (while (setq namm (entnext namm))          ; next subentity ename
         (setq typp (cdr (assoc 0 (setq entt (entget namm)))))
         (if (member typp '("ARC" "CIRCLE"))
 ; Ŀ
 ;   If the subentity was a circle or an arc then append the centre point  
 ;   and radius to the list for later appraisal.                           
 ; 
             (setq clist (append clist (list (list (cdr (assoc 40 entt))
                                               (cdr (assoc 10 entt))))))))
 ; Ŀ
 ;   Should now have a list of lists: centre and radius for each arc or    
 ;   circle in the block.  If the block contained no circles then clist    
 ;   will be nil and the the routine should end.                           
 ; 
 ; Ŀ
 ;   Now find the largest arc/circle (assumed to be the outline.)          
 ;   More complex criteria can be considered, but 99% of the time there    
 ;   will only be one circle.  It is not realistically possible to         
 ;   anticipate the circumstances which would lead to the use of this      
 ;   routine on a block containing multiple or offset circles, and it is   
 ;   impossible to foresee what the design of the block would be.          
 ; 
 ; Ŀ
 ;   If there are no circles or arcs in the block, return a zero radius    
 ;   and the block insertion point.                                        
 ; 
  (cond ((null clist)
         (setq grsub '(0 (0 0 0))))
 ; Ŀ
 ;   If there is only one circle or arc in the block, use it.              
 ; 
        ((= (length clist) 1)
         (setq grsub (car clist)))
 ; Ŀ
 ;   If there are > 1.                                                     
 ; 
        ((> (length clist) 1)
         (setq sub (nth 0 clist))
         (setq grsub sub)
         (setq grdiam (car sub))
         (setq num 1)
         (while (setq sub (nth num clist))
                (if (> (car sub) grdiam)
                    (progn
                        (setq grsub sub)
                        (setq grdiam (car sub))))
                (setq num (1+ num)))))
 grsub)
 ; Ŀ
 ;   Subroutine Acirc end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Cfind - find the circle, arc or insert nearest to a point. 
 ;   Arguments: pa, a point (typically the end of a line).                 
 ;              pb, a point (the other line end, for finding the search    
 ;                  start angle, so not strictly essential).               
 ;   Returns an entity name.                                               
 ; 
 (DEFUN CFIND (pa pb / pasav pbsav outrag leninc stangl anginc num pb ss pa)
  (setq pasav pa)
  (setq pbsav pb)
  (setq outrag (* 5 (misps)))
  (setq leninc (/ outrag 60.0))
  (setq stangl (angle pb pa))
  (setq anginc (/ pi 60))
  (setq num 0)
  (while (and (null ss) (< num 1000))
;         (command ".delay" "1")       ; if you would like it slower.
         (setq num (1+ num))
         (setq pb (polar pa stangl outrag))
         (grdraw pa pb -1)
         (princ)
         (setq ss (ssget "f" (list pa pb) '((-4 . "<or") (0 . "circle")
                                     (0 . "arc") (0 . "insert") (-4 . "or>"))))
         (setq outrag (+ outrag leninc))
         (setq stangl (+ stangl anginc)))
  (setq outrag (* 5 (misps)))
  (setq pa pasav)
  (setq pb pbsav)
  (setq stangl (angle pb pa))
  (repeat num
         (setq pb (polar pa stangl outrag))
         (grdraw pa pb -1)
         (princ)
         (setq outrag (+ outrag leninc))
         (setq stangl (+ stangl anginc)))
  (if ss (ssname ss 0)))
 ; Ŀ
 ;   Cfind end.                                                            
 ; 

 ; Ŀ
 ;   Clc - neaten an ss if it contains a line and two circle-like things.  
 ;   Arguments: ss, a selection set of stuff to neaten.                    
 ;   Calls Cfind, returns nothing.  Likes souvlaki.                        
 ; 
 (DEFUN CLC (ss / num curent ctyp acirc1 acirc2 aline entt cdat radi1 pa1
                                              radi2 pa2 end1 end2 ten elv)
 ; Ŀ
 ;   Must have two of either arcs or circles or blocks containing arcs or  
 ;   circles and one line.                                                 
 ; 
  (setq num 0)
  (while (and (setq curent (ssname ss num))
              (or (null acirc1) (null acirc2) (null aline)))
         (setq num (1+ num))
 ; Ŀ
 ;   Figure out what the entity was, save it if it is ok.                  
 ; 
         (setq ctyp (cdr (assoc 0 (entget curent))))
         (cond ((or (= ctyp "CIRCLE") (= ctyp "ARC")
                    (and (= ctyp "INSERT")
                         (cadr (fcen curent))))
                (cond ((null acirc1) (setq acirc1 curent))
                      ((null acirc2) (setq acirc2 curent))))
               ((= ctyp "LINE")
                (if (null aline) (setq aline curent)))))
 ; Ŀ
 ;   If we have the required entities, commit:                             
 ;   Get circle/arc centres and radii.                                     
 ; 
  (if (and acirc1 acirc2 aline)
      (progn
           (setq entt (entget acirc1))
           (if (= (cdr (assoc 0 entt)) "INSERT")
               (progn
                    (setq cdat (fcen acirc1))
                    (setq radi1 (car cdat))
                    (setq pa1 (cadr cdat)))
               (progn
                    (setq radi1 (cdr (assoc 40 entt)))
                    (setq pa1 (cdr (assoc 10 entt)))))

           (setq entt (entget acirc2))
           (if (= (cdr (assoc 0 entt)) "INSERT")
               (progn
                    (setq cdat (fcen acirc2))
                    (setq radi2 (car cdat))
                    (setq pa2 (cadr cdat)))
               (progn
                    (setq radi2 (cdr (assoc 40 entt)))
                    (setq pa2 (cdr (assoc 10 entt)))))
 ; Ŀ
 ;   Deduce the required line endpoints.                                   
 ; 
           (setq end1 (polar pa1 (angle pa1 pa2) radi1))
           (setq end2 (polar pa2 (angle pa2 pa1) radi2))
 ; Ŀ
 ;   Change the line.                                                      
 ; 
           (setq entt (entget aline))
           (setq ten (assoc 10 entt))
           (setq elv (assoc 11 entt))
           (setq entt (subst (cons 10 end1) ten entt))
           (entmod (subst (cons 11 end2) elv entt)))
 ; Ŀ
 ;   If something was wrong, remark on it.                                 
 ; 
      (prompt "Inadequate entity set."))
 (princ))
 ; Ŀ
 ;   Clc end.                                                              
 ; 

 ; Ŀ
 ;   Fcen - find the centre and radius of a circle or arc in a block.      
 ;   Calls Acirc.                                                          
 ;   Argument: Blocnm, the ename of the block.                             
 ;   Returns a list of a radius and a centre point.                        
 ; 
 (DEFUN FCEN (blocnm / bldat blint blex bly blz rota grsub cen radi dist ang)
  (setq bldat (entget blocnm))
 ; Ŀ
 ;   Get block data.                                                       
 ; 
  (setq blint (cdr (assoc 10 bldat)))          ; insertion point
  (setq blex (cdr (assoc 41 bldat)))           ; X scale
  (setq bly (cdr (assoc 42 bldat)))            ; Y scale
  (setq blz (cdr (assoc 43 bldat)))            ; Z scale
  (setq rota (cdr (assoc 50 bldat)))           ; rotation
  (setq grsub (acirc bldat))                   ; call acirc
  (if grsub
     (progn
          (setq cen (cadr grsub))              ; offset of centre from ins.
          (setq radi (car grsub))              ; circle radius
 ; Ŀ
 ;   Cen is an offset from the centre of the circle.  Must convert it to   
 ;   a position.  Don't forget the block scale factor.                     
 ; 
          (if (/= (abs blex) (abs bly))        ; i.e. X = Y or X = -Y
              (prompt "\nBlock scale factors are not equal")
              (progn
 ; Ŀ
 ;   Now scale the circle centre offset from the insertion point by the    
 ;   appropriate scale factors.                                            
 ; 
                   (setq cen (list (* blex (car cen))
                                   (* bly (cadr cen))
                                   (* blz (caddr cen))))
 ; Ŀ
 ;   Get the distance and angle from the block insertion to the circle     
 ;   centre.                                                               
 ; 
                   (setq dist (distance (list 0 0 0) cen))
                   (setq ang (angle (list 0 0 0) cen))
 ; Ŀ
 ;   Adjust the angle for the block rotation.                              
 ; 
                   (setq ang (+ ang rota))
 ; Ŀ
 ;   And get the new centre point.                                         
 ; 
                   (setq cen (polar blint ang dist))
 ; Ŀ
 ;   Adjust the radius for block scale.                                    
 ; 
                   (setq radi (* radi blex))))))
 (list radi cen))
 ; Ŀ
 ;   Subroutine Fcen end.                                                  
 ; 

 ; Ŀ
 ;   Fince - find entities at or near the ends of a line, neaten the line. 
 ;   Arguments: Aline, the line ename.                                     
 ;   Calls Cfind, returns nothing.  Likes souvlaki.                        
 ; 
 (DEFUN FINCE (aline / entt ten elv acirc1 acirc2 cdat radi1 pa1 radi2 pa2
                                                                  end1 end2)
 ; Ŀ
 ;   Get a the line data, find the endpoints.                              
 ; 
  (setq entt (entget aline))
  (if (= (cdr (assoc 0 entt)) "LINE")
      (progn
           (setq ten (cdr (assoc 10 entt)))
           (setq elv (cdr (assoc 11 entt)))
 ; Ŀ
 ;   Find the block, circle or arc nearest to each end.                    
 ; 
           (setq acirc1 (cfind ten elv))
           (setq acirc2 (cfind elv ten))
 ; Ŀ
 ;   If we have the required entities, commit:                             
 ;   Get circle/arc centres and radii.                                     
 ; 
           (if (and acirc1 acirc2 aline)
               (progn
                    (setq entt (entget acirc1))
                    (if (= (cdr (assoc 0 entt)) "INSERT")
                        (progn
                             (setq cdat (fcen acirc1))
                             (setq radi1 (car cdat))
                             (setq pa1 (cadr cdat)))
                        (progn
                             (setq radi1 (cdr (assoc 40 entt)))
                             (setq pa1 (cdr (assoc 10 entt)))))
                    (setq entt (entget acirc2))
                    (if (= (cdr (assoc 0 entt)) "INSERT")
                        (progn
                             (setq cdat (fcen acirc2))
                             (setq radi2 (car cdat))
                             (setq pa2 (cadr cdat)))
                        (progn
                             (setq radi2 (cdr (assoc 40 entt)))
                             (setq pa2 (cdr (assoc 10 entt)))))
 ; Ŀ
 ;   Deduce the required line endpoints.                                   
 ; 
                    (setq end1 (polar pa1 (angle pa1 pa2) radi1))
                    (setq end2 (polar pa2 (angle pa2 pa1) radi2))
 ; Ŀ
 ;   Change the line.                                                      
 ; 
                    (setq entt (entget aline))
                    (setq ten (assoc 10 entt))
                    (setq elv (assoc 11 entt))
                    (setq entt (subst (cons 10 end1) ten entt))
                    (entmod (subst (cons 11 end2) elv entt)))))
      (prompt "That wasn't a line."))
 (princ))
 ; Ŀ
 ;   Fince end.                                                            
 ; 

 ; Ŀ
 ;   Lins - make a line perpendicular to a circle in a block.              
 ;   Calls Circ, returns nothing.                                          
 ;   Takes three arguments: Ppt, the pick point.                           
 ;                          Bloc, the block ename.                         
 ;                          Linnam, the line enam.                         
 ; 
 (DEFUN LINS (ppt linnam bloc / lin aa bb circa blint blex bly blz rota grsub
                                         cen radish dist ang disc crang rim)
  (setq lin (entget linnam))
  (setq aa (cdr (assoc 10 lin)))                      ; line start
  (setq bb (cdr (assoc 11 lin)))                      ; line end
  (setq circa (entget bloc))
 ; Ŀ
 ;   Get block data.                                                       
 ; 
  (setq blint (cdr (assoc 10 circa)))          ; insertion point
  (setq blex (cdr (assoc 41 circa)))           ; X scale
  (setq bly (cdr (assoc 42 circa)))            ; Y scale
  (setq blz (cdr (assoc 43 circa)))            ; Z scale
  (setq rota (cdr (assoc 50 circa)))           ; rotation
  (setq grsub (circ circa))                    ; call circ
  (if grsub
     (progn
          (setq cen (cadr grsub))              ; offset centre from ins.
          (setq radish (car grsub))            ; circle radius
 ; Ŀ
 ;   Cen is an offset from the centre of the circle.  Must convert it to   
 ;   a position.  Don't forget the block scale factor.                     
 ; 
          (if (/= (abs blex) (abs bly))        ; i.e. X = Y or X = -Y
              (prompt "\nBlock scale factors are not equal")
              (progn
                   (setq radish (* radish (abs blex))) ; radius x scale
 ; Ŀ
 ;   Now scale the circle centre offset from the insertion point by the    
 ;   appropriate scale factors.                                            
 ; 
                   (setq cen (list (* blex (car cen))
                                   (* bly (cadr cen))
                                   (* blz (caddr cen))))
 ; Ŀ
 ;   Get the distance and angle from the block insertion to the circle     
 ;   centre.                                                               
 ; 
                   (setq dist (distance (list 0 0 0) cen))
                   (setq ang (angle (list 0 0 0) cen))
 ; Ŀ
 ;   Adjust the angle for the block rotation.                              
 ; 
                   (setq ang (+ ang rota))
 ; Ŀ
 ;   And get the new centre point.                                         
 ; 
                   (setq cen (polar blint ang dist))
 ; Ŀ
 ;   Now make the line touch the circle.                                   
 ; 
                   (if (> (distance aa ppt) (distance bb ppt))
                       (progn
                            (setq disc (distance aa cen))   ; line/circle dist.
                            (setq crang (angle aa cen))     ; and angle
                            (setq rim (polar aa crang (- disc radish)))
                            (entmod (subst (cons 11 rim) (assoc 11 lin) lin)))
                       (progn
                            (setq disc (distance bb cen))   ; line/circle dist.
                            (setq crang (angle bb cen))     ; and angle
                            (setq rim (polar bb crang (- disc radish)))
                            (entmod (subst (cons 10 rim)
                                           (assoc 10 lin) lin))))))))
 (princ))
 ; Ŀ
 ;   Subroutine Lins end.                                                  
 ; 

 ; Ŀ
 ;   Crab.                                                                 
 ; 
 (DEFUN C:CRAB (/ *error* angbas blip osmo snapp cd thr ss)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a new error handler.                                             
 ; 
  (defun *error* (shk)
   (setvar "angbase" angbas)
   (setvar "blipmode" blip)
   (setvar "osmode" osmo)
   (setvar "snapmode" snapp)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Turn off snap etc.                                                    
 ; 
  (setq angbas (getvar "angbase"))
  (setvar "angbase" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Prompt for three entities.                                            
 ; 
  (setq cd (getvar "cdate"))
  (setq thr (fix (* 100 (- cd (fix cd)))))
  (if (< 12 thr)
      (progn
           (if (< 17 thr)
               (setq thr "evening")
               (setq thr "afternoon")))
      (setq thr "morning"))
  (prompt (strcat "Good " thr ", please select two circles and/or a line: "))
 ; Ŀ
 ;   Get an ss.                                                            
 ; 
  (setq ss (ssget '((-4 . "<or") (0 . "circle") (0 . "arc") (0 . "line")
                    (0 . "insert") (-4 . "or>"))))
 ; Ŀ
 ;   If the ss contained only one entity and it was a line, call Fince.    
 ;   Otherwise let Clc have a go.                                          
 ; 
  (if (= (sslength ss) 1)
      (fince (ssname ss 0))
      (clc ss))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (*error* "")
 (princ))